/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Web;
using System.Collections;
using Borland.Eco.Handles;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Services;
using Borland.Eco.UmlRt;
using Borland.Eco.Web;

namespace Borland.Eco.Web
{
	/// <summary>
	/// Summary description for ActionExecutor.
	/// </summary>
	public class ActionExecutor
	{
		///<exception cref="ArgumentNullException">Thrown if <paramref name="obj"/> is null.</exception>
		public static void Unlink(EcoSpace ecoSpace, IObject obj, int propertyIndex, string unlinkId)
		{
			if (obj == null)
				throw new ArgumentNullException("obj");
			try
			{
				IObject unlink = WebUtils.ObjectForId(ecoSpace, unlinkId);
				IProperty prop = obj.Properties[propertyIndex];
				EcoPropertyType propType = WebUtils.GetPropertyType(prop);
				if (propType == EcoPropertyType.MultiLink)
					UnlinkMulti(prop as IObjectList, unlink);
				else if (propType == EcoPropertyType.SingleLink)
					UnlinkSingle(prop, unlink);
				WebUtils.SaveSpace(ecoSpace);
			}
			catch { ; }
		}

		///<exception cref="ArgumentNullException">Thrown if <paramref name="list"/> is null.</exception>
		public static void UnlinkMulti(IObjectList list, IObject linked)
		{
			if (list == null)
				throw new ArgumentNullException("list");
			if (linked != null)
				list.Remove(linked);
		}

		///<exception cref="ArgumentNullException">Thrown if <paramref name="prop"/> is null.</exception>
		public static void UnlinkSingle(IProperty prop, IObject linked)
		{
			if (prop == null)
				throw new ArgumentNullException("prop");
			((IObject)prop).Clear() ;
		}

		///<exception cref="ArgumentNullException">Thrown if <paramref name="obj"/> is null.</exception>
		public static void Link(EcoSpace ecoSpace, IObject obj, int propertyIndex, string linkId)
		{
			if (obj == null)
				throw new ArgumentNullException("obj");
			try
			{
				IObject link = WebUtils.ObjectForId(ecoSpace, linkId);
				IProperty prop = obj.Properties[propertyIndex];
				EcoPropertyType propType = WebUtils.GetPropertyType(prop);
				if (propType == EcoPropertyType.MultiLink)
					LinkMulti(prop as IObjectList, link);
				else if (propType == EcoPropertyType.SingleLink)
					LinkSingle(prop, link);
				WebUtils.SaveSpace(ecoSpace);
			}
			catch { ; }
		}

		///<exception cref="ArgumentNullException">Thrown if <paramref name="list"/> is null.</exception>
		public static void LinkMulti(IObjectList list, IObject unlinked)
		{
			if (list == null)
				throw new ArgumentNullException("list");
			if (unlinked != null)
				list.Add(unlinked);
		}

		///<exception cref="ArgumentNullException">Thrown if <paramref name="prop"/> is null.</exception>
		public static void LinkSingle(IProperty prop, IObject unlinked)
		{
			if (prop == null)
				throw new ArgumentNullException("prop");
			prop.Assign(unlinked);
		}

		public static void Delete(EcoSpace ecoSpace, string deleteId)
		{
			try
			{
				IObject obj = WebUtils.ObjectForId(ecoSpace, deleteId);
				Delete(ecoSpace, obj);
			}
			catch { ; }
		}

		///<exception cref="ArgumentNullException">Thrown if <paramref name="obj"/> is null.</exception>
		public static void Delete(EcoSpace ecoSpace, IObject obj)
		{
			if (obj == null)
				throw new ArgumentNullException("obj");
			try
			{
				obj.Delete();
				WebUtils.SaveSpace(ecoSpace);
			}
			catch { ; }
		}

		///<exception cref="ArgumentNullException">Thrown if <paramref name="ecoSpace"/> is null.</exception>
		public static IObject Create(EcoSpace ecoSpace, string className)
		{
			if (ecoSpace == null)
				throw new ArgumentNullException("ecoSpace");
			try
			{
				IObjectFactoryService factory = (IObjectFactoryService) ecoSpace.GetEcoService(typeof(IObjectFactoryService));
				IObject obj = factory.CreateNewObject(className);
				WebUtils.SaveSpace(ecoSpace);
				return obj;
			}
			catch { return null; }
		}
	}
}
